import 'dart:convert';
import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:viserpay_merchant/data/model/invoice/invoice_history_response_model.dart';

import '../../../core/helper/string_format_helper.dart';
import '../../../core/utils/my_color.dart';
import '../../../core/utils/my_strings.dart';
import '../../../view/components/bottom-sheet/custom_bottom_sheet.dart';
import '../../../view/components/snack_bar/show_custom_snackbar.dart';
import '../../../view/screens/invoice/update_invoice/widget/update_invoice_preview_bottom_sheet.dart';
import '../../model/authorization/authorization_response_model.dart';
import '../../model/global/response_model/response_model.dart';
import '../../model/invoice/invoice_items_model.dart';
import '../../model/invoice/update_invoice_response_model.dart';
import '../../repo/invoice/update_invoice_repo.dart';

class UpdateInvoiceController extends GetxController {
  UpdateInvoiceRepo updateInvoiceRepo;
  UpdateInvoiceController({required this.updateInvoiceRepo});

  bool isLoading = true;
  UpdateInvoiceResponseModel model = UpdateInvoiceResponseModel();

  List<InvoiceItemsModel> invoiceItemList = [];

  TextEditingController invoiceItemController = TextEditingController();
  TextEditingController invoiceAmountController = TextEditingController();
  TextEditingController cancelReasonController = TextEditingController();

  void increaseNumberField() {
    invoiceItemList.add(InvoiceItemsModel(itemNameController: TextEditingController(), amountController: TextEditingController()));
    update();
  }

  void decreaseNumberField(int index) {
    invoiceItemList.removeAt(index);
    calculateInvoiceAmount();
    update();
  }

  PaymentCharge paymentChargeData = PaymentCharge();
  String invoiceNumber = "";
  Future<void> loadData({required String invoiceNum, required PaymentCharge paymentCharge}) async {
    isLoading = true;
    update();
    invoiceNum = invoiceNum;
    paymentChargeData = paymentCharge;
    try {
      ResponseModel responseModel = await updateInvoiceRepo.getData(invoiceNum: invoiceNum);
      if (responseModel.statusCode == 200) {
        model = UpdateInvoiceResponseModel.fromJson(jsonDecode(responseModel.responseJson));

        totalInvoiceAmount = StringConverter.formatNumber(model.data?.invoice?.totalAmount ?? "");

        if (model.status.toString().toLowerCase() == MyStrings.success.toLowerCase()) {
          List<InvoiceItem>? tempInvoiceItemList = model.data?.invoice?.invoiceItem ?? [];
          if (tempInvoiceItemList.isNotEmpty) {
            for (var element in tempInvoiceItemList) {
              String itemName = element.name ?? "";
              String amount = StringConverter.formatNumber(element.price ?? "");
              InvoiceItemsModel items = InvoiceItemsModel(itemNameController: TextEditingController(text: itemName), amountController: TextEditingController(text: amount));
              invoiceItemList.add(items);
            }
          }
        } else {
          CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message]);
      }
    } catch (e) {}

    calculateInvoiceAmount();
    isLoading = false;
    update();
  }

  void submitUpdateInvoice() {
    calculateInvoiceAmount();
    CustomBottomSheet(child: const UpdateInvoicePreviewBottomSheet()).customBottomSheet(Get.context!);
  }

  bool submitLoading = false;
  Future<void> updateInvoice() async {
    String invoiceId = model.data?.invoice?.id.toString() ?? "";

    String invoiceName = invoiceItemController.text.toString();
    String invoiceAmount = invoiceAmountController.text.toString();

    submitLoading = true;
    update();

    ResponseModel responseModel = await updateInvoiceRepo.updateInvoice(invoiceId: invoiceId, invoiceItemName: invoiceName, invoiceAmount: invoiceAmount, invoiceItemList: invoiceItemList);

    if (responseModel.statusCode == 200) {
      AuthorizationResponseModel model = AuthorizationResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      if (model.status.toString().toLowerCase() == MyStrings.success.toLowerCase()) {
        Get.back();
        // Get.back(result: 'success');
        CustomSnackBar.success(successList: model.message?.success ?? [MyStrings.requestSuccess]);
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }

    submitLoading = false;
    update();
  }

  bool isSendToEmailLoading = false;
  Future<void> invoiceSendToEmail() async {
    String invoiceId = model.data?.invoice?.id.toString() ?? "";

    isSendToEmailLoading = true;
    update();
    ResponseModel responseModel = await updateInvoiceRepo.sendToEmail(invoiceId);
    if (responseModel.statusCode == 200) {
      AuthorizationResponseModel model = AuthorizationResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      if (model.status.toString().toLowerCase() == "success") {
        CustomSnackBar.success(successList: model.message?.success ?? [MyStrings.requestSuccess]);
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }
    isSendToEmailLoading = false;
    update();
  }

  bool isPublishInvoiceLoading = false;
  Future<void> publishInvoice() async {
    String invoiceId = model.data?.invoice?.id.toString() ?? "";

    isPublishInvoiceLoading = true;
    update();
    ResponseModel responseModel = await updateInvoiceRepo.publishInvoice(invoiceId);
    if (responseModel.statusCode == 200) {
      AuthorizationResponseModel model = AuthorizationResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      if (model.status.toString().toLowerCase() == "success") {
        Get.back(result: 'success');
        CustomSnackBar.success(successList: model.message?.success ?? [MyStrings.requestSuccess]);
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }
    isPublishInvoiceLoading = false;
    update();
  }

  bool isDiscardInvoiceLoading = false;

  Future<void> cancelInvoice(String cancelReason) async {
    String invoiceId = model.data?.invoice?.id.toString() ?? "";

    isDiscardInvoiceLoading = true;
    update();
    ResponseModel responseModel = await updateInvoiceRepo.cancelInvoice(invoiceId, cancelReason);
    if (responseModel.statusCode == 200) {
      AuthorizationResponseModel model = AuthorizationResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        Get.back(result: 'success');
        CustomSnackBar.success(successList: model.message?.success ?? [MyStrings.requestSuccess]);
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.requestFail]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }
    isDiscardInvoiceLoading = false;
    update();
  }

  dynamic getStatusOrColor(int index, {bool isStatus = true}) {
    String status = model.data?.invoice?.status ?? '';

    if (isStatus) {
      String text = status == "0"
          ? MyStrings.unpaid
          : status == "1"
              ? MyStrings.paid
              : status == "2"
                  ? MyStrings.rejected
                  : status == "3"
                      ? MyStrings.canceled
                      : "";
      return text;
    } else {
      Color color = status == "0"
          ? MyColor.highPriorityPurpleColor
          : status == "1"
              ? MyColor.colorGreen
              : status == "2"
                  ? MyColor.colorRed
                  : MyColor.colorOrange;
      return color;
    }
  }

  String totalInvoiceAmount = '0.00';
  String charge = '0.00';
  String getableText = '0.00';

  void calculateInvoiceAmount() {
    double totalAmount = 0;

    for (var invoice in invoiceItemList) {
      double invoiceAmount = double.tryParse(invoice.amountController.text) ?? 0;
      totalAmount = totalAmount + invoiceAmount;
    }

    totalInvoiceAmount = StringConverter.formatNumber(totalAmount.toString(), precision: 2);
    double cap = double.tryParse(paymentChargeData.cap ?? "0") ?? 0;
    double percent = double.tryParse(paymentChargeData.merchantPaymentPercentCharge ?? "0") ?? 0;
    double percentCharge = totalAmount * percent / 100;

    double fixedCharge = double.tryParse(paymentChargeData.merchantPaymentFixedCharge ?? "0") ?? 0;

    double totalCharge = percentCharge + fixedCharge;

    if (cap != -1.0 && cap != 1 && totalCharge > cap) {
      totalCharge = cap;
    }

    charge = StringConverter.formatNumber('$totalCharge', precision: 2);

    double payable = totalAmount - totalCharge;
    getableText = StringConverter.formatNumber(payable.toString(), precision: 2);

    update();
  }
}
